string GetDescription()
{
	return "Renders the harmony into arpegiated chords. Has many patterns of arpeggio.";
}

int[][] arp = { { 0,2,1,2 },
				{ 0,1,2,1 },
				{ 0,1,2,3 },
				{ 0,1,2,3 },
				{ 2,0,3,0 },
				{ 2,0,1,0 },
				{ 0,1,2,3,2,1},
				{ 0,1,2},
				{ 0,2,3},
				{ 0,2,4},
				{ 0,1,2,3,4,5,6,7 }
			};

void Render(RenderPart @p)
{
	Time t = CreateTime(p.GetStartBar(), 0);
	
	double basic_tempo;
	
	if (p.GetTempo() > 140)
	{
		basic_tempo = 0.5;
	}
	else
	{
		basic_tempo = 0.25;
	}
	
	double len = basic_tempo;
	
	int len_mode = RndInt(0,2);
	
	if (len_mode == 0) len = basic_tempo;
	if (len_mode == 1) len = basic_tempo * 0.5;
	if (len_mode == 2) len = basic_tempo * 0.75;
		
	int a = RndInt(0, arp.length()-1);
	int note = 0;
	int old_nhp = -1;
	
	int reset_on_bar = RndInt(0,1);
	int reset_on_chord_change = RndInt(0,1);
	
	while (t.m_Bar < p.GetEndBar())
	{
		Time t2;
		t2.m_Bar = t.m_Bar;
		t2.m_Pos = t.m_Pos + len; 
		
		int nnhp = p.GetHarmonicEventPitch(p.GetHarmonic(t), 0 );
		if (nnhp != old_nhp && reset_on_chord_change == 1)
		{
			note = 0;
			old_nhp = nnhp;	
		}
		
		p.AddNote(t, t2, p.GetHarmonicEventPitch(p.GetHarmonic(t), arp[a][note] ) , RndInt(100,125));	
				
		note = (note + 1) % arp[a].length();
		
		t.m_Pos += basic_tempo;
		if (t.m_Pos >= p.GetUniquePart().GetMetrum())
		{
			t.m_Bar++;
			t.m_Pos = 0;	
			if (reset_on_bar == 1) note = 0;
		}
	}
}
